package examples.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

enum Visibility {
    INTERNAL, PUBLIC 
}

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface CodeCategory {   
    Visibility visibility() default Visibility.INTERNAL;
    boolean isUnitTested() default false;
    boolean isReviewed() default false;
}
